/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polygon2DUtils;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rectangle2D
implements Polygon2D {
    protected double x0;
    protected double y0;
    protected double w;
    protected double h;
    protected double theta;

    public Rectangle2D(double x0, double y0, double w, double h, double theta) {
        this.x0 = x0;
        this.y0 = y0;
        this.w = w;
        this.h = h;
        this.theta = theta;
    }

    public Rectangle2D() {
        this(0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Rectangle2D(java.awt.geom.Rectangle2D rect) {
        this.x0 = rect.getX();
        this.y0 = rect.getY();
        this.w = rect.getWidth();
        this.h = rect.getHeight();
        this.theta = 0.0;
    }

    public Rectangle2D(double x0, double y0, double w, double h) {
        this.x0 = x0;
        this.y0 = y0;
        this.w = w;
        this.h = h;
        this.theta = 0.0;
    }

    public Rectangle2D(Point2D point, double w, double h, double theta) {
        this.x0 = point.getX();
        this.y0 = point.getY();
        this.w = w;
        this.h = h;
        this.theta = theta;
    }

    public Rectangle2D(Point2D point, double w, double h) {
        this.x0 = point.getX();
        this.y0 = point.getY();
        this.w = w;
        this.h = h;
        this.theta = 0.0;
    }

    public double getX() {
        return this.x0;
    }

    public double getY() {
        return this.y0;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public double getTheta() {
        return this.theta;
    }

    public Point2D getCenter() {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double xc = this.x0 + this.w * cot / 2.0 - this.h * sit / 2.0;
        double yc = this.y0 + this.w * sit / 2.0 + this.h * cot / 2.0;
        return new Point2D(xc, yc);
    }

    @Deprecated
    public void setRectangle(Rectangle2D rect) {
        this.x0 = rect.x0;
        this.y0 = rect.y0;
        this.w = rect.w;
        this.h = rect.h;
        this.theta = rect.theta;
    }

    @Deprecated
    public void setRectangle(java.awt.geom.Rectangle2D rect) {
        this.x0 = rect.getX();
        this.y0 = rect.getY();
        this.w = rect.getWidth();
        this.h = rect.getHeight();
        this.theta = 0.0;
    }

    @Deprecated
    public void setRectangle(double x, double y, double width, double height, double theta) {
        this.x0 = x;
        this.y0 = y;
        this.w = width;
        this.h = height;
        this.theta = theta;
    }

    @Override
    public Collection<Point2D> getVertices() {
        AffineTransform2D rot = AffineTransform2D.createRotation(this.x0, this.y0, this.theta);
        ArrayList<Point2D> array = new ArrayList<Point2D>(4);
        array.add(new Point2D(this.x0, this.y0).transform(rot));
        array.add(new Point2D(this.x0 + this.w, this.y0).transform(rot));
        array.add(new Point2D(this.x0 + this.w, this.y0 + this.h).transform(rot));
        array.add(new Point2D(this.x0, this.y0 + this.h).transform(rot));
        return array;
    }

    @Override
    public int getVertexNumber() {
        return 4;
    }

    @Override
    public Point2D getVertex(int i) {
        AffineTransform2D rot = AffineTransform2D.createRotation(this.x0, this.y0, this.theta);
        switch (i) {
            case 0: {
                return new Point2D(this.x0, this.y0).transform(rot);
            }
            case 1: {
                return new Point2D(this.x0 + this.w, this.y0).transform(rot);
            }
            case 2: {
                return new Point2D(this.x0 + this.w, this.y0 + this.h).transform(rot);
            }
            case 3: {
                return new Point2D(this.x0, this.y0 + this.h).transform(rot);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Collection<LineSegment2D> getEdges() {
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(4);
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double x1 = this.w * cot + this.x0;
        double y1 = this.w * sit + this.y0;
        double x2 = this.w * cot - this.h * sit + this.x0;
        double y2 = this.w * sit + this.h * cot + this.y0;
        double x3 = -this.h * sit + this.x0;
        double y3 = this.h * cot + this.y0;
        edges.add(new LineSegment2D(this.x0, this.y0, x1, y1));
        edges.add(new LineSegment2D(x1, y1, x2, y2));
        edges.add(new LineSegment2D(x2, y2, x3, y3));
        edges.add(new LineSegment2D(x3, y3, this.x0, this.y0));
        return edges;
    }

    @Override
    public int getEdgeNumber() {
        return 4;
    }

    public Collection<LinearRing2D> getRings() {
        ArrayList<LinearRing2D> rings = new ArrayList<LinearRing2D>(1);
        rings.add(new LinearRing2D(this.getVertices()));
        return rings;
    }

    @Override
    public double getArea() {
        return Math.abs(this.getSignedArea());
    }

    @Override
    public double getSignedArea() {
        return Polygon2DUtils.computeSignedArea(this);
    }

    @Override
    public Point2D getCentroid() {
        return Polygon2DUtils.computeCentroid(this);
    }

    @Override
    public CirculinearDomain2D transform(CircleInversion2D inv) {
        return new GenericCirculinearDomain2D((CirculinearBoundary2D)((CirculinearContourArray2D)this.getBoundary()).transform(inv));
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer((CirculinearCurve2D)((Object)this.getBoundary()), dist);
    }

    @Override
    public CirculinearContourArray2D<LinearRing2D> getBoundary() {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        Point2D[] pts = new Point2D[]{new Point2D(this.x0, this.y0), new Point2D(this.w * cot + this.x0, this.w * sit + this.y0), new Point2D(this.w * cot - this.h * sit + this.x0, this.w * sit + this.h * cot + this.y0), new Point2D(-this.h * sit + this.x0, this.h * cot + this.y0)};
        return new CirculinearContourArray2D<LinearRing2D>(new LinearRing2D(pts));
    }

    @Override
    public Polygon2D complement() {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        Point2D[] pts = new Point2D[]{new Point2D(this.x0, this.y0), new Point2D(-this.h * sit + this.x0, this.h * cot + this.y0), new Point2D(this.w * cot - this.h * sit + this.x0, this.w * sit + this.h * cot + this.y0), new Point2D(this.w * cot + this.x0, this.w * sit + this.y0)};
        return new SimplePolygon2D(pts);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public double getDistance(Point2D p) {
        return Math.max(this.getSignedDistance(p.getX(), p.getY()), 0.0);
    }

    @Override
    public double getDistance(double x, double y) {
        return Math.max(this.getSignedDistance(x, y), 0.0);
    }

    public double getSignedDistance(Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    public double getSignedDistance(double x, double y) {
        double dist = ((CurveArray2D)((Object)this.getBoundary())).getDistance(x, y);
        if (this.contains(x, y)) {
            return -dist;
        }
        return dist;
    }

    @Override
    public Polygon2D clip(Box2D box) {
        return Polygon2DUtils.clipPolygon(this, box);
    }

    @Override
    public Box2D getBoundingBox() {
        double xmin = this.x0;
        double xmax = this.x0;
        double ymin = this.y0;
        double ymax = this.y0;
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double x = this.w * cot + this.x0;
        double y = this.w * sit + this.y0;
        if (xmin > x) {
            xmin = x;
        }
        if (ymin > y) {
            ymin = y;
        }
        if (xmax < x) {
            xmax = x;
        }
        if (ymax < y) {
            ymax = y;
        }
        x = this.w * cot - this.h * sit + this.x0;
        y = this.w * sit + this.h * cot + this.y0;
        if (xmin > x) {
            xmin = x;
        }
        if (ymin > y) {
            ymin = y;
        }
        if (xmax < x) {
            xmax = x;
        }
        if (ymax < y) {
            ymax = y;
        }
        x = this.h * sit + this.x0;
        y = this.h * cot + this.y0;
        if (xmin > x) {
            xmin = x;
        }
        if (ymin > y) {
            ymin = y;
        }
        if (xmax < x) {
            xmax = x;
        }
        if (ymax < y) {
            ymax = y;
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public SimplePolygon2D transform(AffineTransform2D trans) {
        int nPoints = 4;
        Point2D[] array = new Point2D[nPoints];
        Point2D[] res = new Point2D[nPoints];
        Iterator<Point2D> iter = this.getVertices().iterator();
        int i = 0;
        while (i < nPoints) {
            array[i] = iter.next();
            res[i] = new Point2D();
            ++i;
        }
        trans.transform(array, res);
        return new SimplePolygon2D(res);
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double x1 = this.w * cot + this.x0;
        double y1 = this.w * sit + this.y0;
        double x2 = this.w * cot - this.h * sit + this.x0;
        double y2 = this.w * sit + this.h * cot + this.y0;
        double x3 = -this.h * sit + this.x0;
        double y3 = this.h * cot + this.y0;
        StraightLine2D line = new StraightLine2D(this.x0, this.y0, x1 - this.x0, y1 - this.y0);
        if (line.getSignedDistance(x, y) > 0.0) {
            return false;
        }
        line = new StraightLine2D(x1, y1, x2 - x1, y2 - y1);
        if (line.getSignedDistance(x, y) > 0.0) {
            return false;
        }
        line = new StraightLine2D(x2, y2, x3 - x2, y3 - y2);
        if (line.getSignedDistance(x, y) > 0.0) {
            return false;
        }
        line = new StraightLine2D(x3, y3, this.x0 - x3, this.y0 - y3);
        return !(line.getSignedDistance(x, y) > 0.0);
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(((CurveArray2D)((Object)this.getBoundary())).getGeneralPath());
    }

    @Override
    public void fill(Graphics2D g) {
        g.fill(((CurveArray2D)((Object)this.getBoundary())).getGeneralPath());
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D rect = (Rectangle2D)obj;
        for (Point2D point : this.getVertices()) {
            boolean ok = false;
            for (Point2D point2 : rect.getVertices()) {
                if (!point.almostEquals(point2, eps)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D rect = (Rectangle2D)obj;
        for (Point2D point : this.getVertices()) {
            boolean ok = false;
            for (Point2D point2 : rect.getVertices()) {
                if (!point.equals(point2)) continue;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }
}

